<?php 
   /*
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../template/stile.php";
    
    include "include/controlloLogin.php";
    // solo i super admin possono creare gli utenti
    if($_SESSION["geecomAdmin_ruolo"]!="super admin") {
        header("Location: {$percorsoBase}index.php");
        exit();
    }
    
    if(isset($_GET["id"])) {
        $utente = $geecomDb->leggiSingolaRiga("geec_utenti",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
    
    $tipiUtente = ["super admin","amministratore","addetto ai documenti","autore","utente"];
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
        <title>Geecom Doc - Creazione utente</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>

    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <form action="../controller/controllerUtenti.php" method="post">
                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($utente) ? "modificaUtente" : "creaUtente")); ?>">
                <input type="text" class="d-none" name="idUtente" value="<?php echo((isset($utente) ? $utente["id"] : "0")); ?>">
                
                <div class="row py-4">                        
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Utente creato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                            <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==220) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Utente modificato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                            <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==230) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Utente duplicato, modificalo per renderlo diverso
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                            <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>

                    <div class="col-lg-8">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="gestioneUtenti.php">Utenti</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($utente)? $utente["nome"]." ".$utente["cognome"] : "Nuovo utente"))?></li>
                                    </ol>
                                </nav>
                            </div>
                            
                            <div class="col-auto text-right">
                                <a class="btn btn-primary mr-1" href="creaUtente.php">Crea nuovo<i class="fas fa-plus ml-2"></i></a>
                                <a class="btn btn-outline-primary" href="gestioneUtenti.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <div class="card-header">
                                <div class="form-inline d-flex justify-content-end">
                                    <label class="mr-2">Ruolo</label>
                                    <select name="ruolo" class="form-control">
                                        <?php 
                                            foreach($tipiUtente as $tipo) {
                                            	  if(isset($utente)) {
                                            	  	$stringaSelezionata = ($utente["ruolo"]==$tipo) ? "selected" : "";
                                            	  }
                                            	  else { // se non è selezionato l'utente
                                            	  	$stringaSelezionata = ($tipo=="utente") ? "selected" : "";
                                            	  }
                                                echo"<option value=\"$tipo\" $stringaSelezionata>$tipo</option>";
                                            }
                                        ?>
                                    </select>
                                    
                                    <label class="mr-2 ml-3">Stato</label>
                                    <select name="stato" class="form-control">
                                        <?php 
                                            $tipiDiStato = array("attivato","non attivato");
                                            foreach($tipiDiStato as $stato) {
                                                if(isset($utente) && $stato==$utente["stato"]) {
                                                    echo"<option value=\"{$stato}\" selected> {$stato}</option>";
                                                }
                                                else {
                                                    echo"<option value=\"{$stato}\"> {$stato}</option>";
                                                }
                                            }
                                        ?>
                                    </select>
                                    
                                    <label class="mr-2 ml-3"for="nome">Ricezione mail</label>
                                    <input type="checkbox" name="ricezioneMail" class="js-switch" value="si" <?php echo((isset($utente) && $utente["ricezioneMail"]=="si") ? "checked" : "")?> />
                                </div>
                            </div>
                            <div class="card-body wrapper-sezioni-pagina">
                                <div class="row">
                                    <div class="form-group col-lg-5">
                                        <label for="nome">Nome</label>
                                        <input  type="text" class="form-control" id="nome" name="nome" value="<?php echo((isset($utente)? $utente["nome"] : ""))?>" placeholder="Nome">
                                    </div>
                                    
                                    <div class="form-group col-lg-5">
                                        <label for="cognome">Cognome</label>
                                        <input  type="text" class="form-control" id="cognome" name="cognome" value="<?php echo((isset($utente)? $utente["cognome"] : ""))?>" placeholder="Cognome">
                                    </div>
                                    
                                    <div class="form-group col-lg-2 ">
                                        <label for="sesso">Sesso</label>
                                        <select class="form-control" id="sesso" name="sesso">
                                            <?php 
                                                $sesso = [""=>"Seleziona","F"=>"Femmina","M"=>"Maschio"];

                                                foreach($sesso as $sigla=>$sessoEsteso) {
                                                        $selezionato = (isset($utente) && $utente["sesso"]==$sigla) ? "selected" : "";
                                                        ?>
                                                        <option value="<?= $sigla ?>" <?= $selezionato ?>><?= $sessoEsteso ?></option>
                                                        <?php
                                                }
                                            ?>
                                        </select>
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label for="via">Via</label>
                                        <input  type="text" class="form-control" id="via" name="via" value="<?php echo((isset($utente)? $utente["via"] : ""))?>" placeholder="Via">
                                    </div>
                                    
                                    <div class="form-group col-lg-4">
                                        <label for="citta">Città</label>
                                        <input  type="text" class="form-control" id="citta" name="citta" value="<?php echo((isset($utente)? $utente["citta"] : ""))?>" placeholder="Città">
                                    </div>
                                    
                                    <div class="form-group col-lg-2 ">
                                        <label for="cap">CAP</label>
                                        <input  type="text" class="form-control" id="cap" name="cap" value="<?php echo((isset($utente)? $utente["cap"] : ""))?>" placeholder="CAP">
                                    </div>
									
                                    <div class="form-group col-lg-6 ">
                                        <label for="luogoNascita">Luogo di nascita</label>
                                        <input  type="text" class="form-control" id="luogoNascita" name="luogoNascita" value="<?php echo((isset($utente)? $utente["luogoNascita"] : ""))?>" placeholder="Luogo di nascita">
                                    </div>
                                    
                                    <div class="form-group col-lg-3">
                                        <label for="provinciaNascita">Provincia di nascita</label>
                                        <input  type="text" class="form-control" id="provinciaNascita" name="provinciaNascita" value="<?php echo((isset($utente)? $utente["luogoNascita"] : ""))?>" placeholder="Provincia di nascita">
                                    </div>
									
                                    <div class="form-group col-lg-3">
                                        <label for="dataNascita">Data di nascita</label>
                                        <input  type="date" class="form-control" id="dataNascita" name="dataNascita" value="<?php echo((isset($utente) && $utente["dataNascita"]!="") ? $utente["dataNascita"] : "") ?>">
                                    </div>
									
                                    <div class="form-group col-lg-6">
                                        <label for="email">Email</label>
                                        <input  type="text" class="form-control" id="email" name="email" value="<?php echo((isset($utente)? $utente["email"] : ""))?>" placeholder="Email">
                                    </div>
                                    
                                    <div class="form-group col-lg-6">
                                        <label for="passwordUtente">Password</label>
                                        <input  type="text" class="form-control" id="passwordUtente" name="password" placeholder="Password">
                                        <small class="text-muted"><?php echo(isset($utente) ? "Compila questo campo per cambiare la password dell'utente" : "Inserisci una password per questo utente") ?></small>
                                    </div>
                                    
                                    <div class="form-group col-lg-6">
                                        <label for="pec">PEC</label>
                                        <input  type="text" class="form-control" id="pec" name="pec" value="<?php echo((isset($utente)? $utente["pec"] : ""))?>" placeholder="PEC">
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label for="telefono">Telefono</label>
                                        <input  type="text" class="form-control" id="telefono" name="telefono" value="<?php echo((isset($utente)? $utente["telefono"] : ""))?>" placeholder="Telefono">
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label for="sitoWeb">Sito web</label>
                                        <input  type="text" class="form-control" id="sitoWeb" name="sitoWeb" value="<?php echo((isset($utente)? $utente["sitoWeb"] : ""))?>" placeholder="Sito web">
                                    </div>                                
                                
                                    <div class="form-group col-lg-6">
                                        <label for="organizzazione">Organizzazione</label>
                                        <input  type="text" class="form-control" id="organizzazione" name="organizzazione" value="<?php echo((isset($utente)? $utente["organizzazione"] : ""))?>" placeholder="Organizzazione">
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label for="codiceFiscale">Codice fiscale</label>
                                        <input  type="text" class="form-control" id="codiceFiscale" name="codiceFiscale" value="<?php echo((isset($utente)? $utente["codiceFiscale"] : ""))?>" placeholder="Codice fiscale">
                                    </div>
                                    
                                    <div class="form-group col-lg-6">
                                        <label for="partitaIva">Partita IVA</label>
                                        <input  type="text" class="form-control" id="partitaIva" name="partitaIva" value="<?php echo((isset($utente)? $utente["partitaIva"] : ""))?>" placeholder="Partita IVA">
                                    </div>
                                    
                                    <div class="form-group col-lg-6">
                                        <label for="codiceInterscambio">Codice interscambio</label>
                                        <input  type="text" class="form-control" id="codiceInterscambio" name="codiceInterscambio" value="<?php echo((isset($utente)? $utente["codiceInterscambio"] : ""))?>" placeholder="Codice interscambio">
                                    </div>
									
                                    <div class="form-group col-12">
                                        <label for="descrizione">Descrizione</label>
                                        <textarea class="form-control" id="descrizione" name="descrizione" rows="2"><?php echo((isset($utente)? $utente["descrizione"] : ""))?></textarea>
                                        <small class="text-muted"> La descrizione verrà mostrata nel profilo utente, l'utente può modificarla.</small>
                                    </div>

                                    <div class="form-group col-12">
                                        <label for="note">Note</label>
                                        <textarea class="form-control" id="note" name="note" rows="2"><?php echo((isset($utente)? $utente["note"] : ""))?></textarea>
                                        <small class="text-muted"> Il campo note non viene visto dall'utente, è uno spazio dove gli amministratori possono inserire delle annotazioni su questo utente specifico. </small>
                                    </div>
                                </div>
                                
                                <button type="submit" class="btn btn-primary float-right mt-3"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div><!--/Colonna principale -->
                    <!-- Colonna principale -->
                    
                    <!--Colonna secondaria -->
                    <div class="col-lg-4 align-self-start sticky-top">
                        <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                            <button type="submit" class="btn btn-primary w-100"><i class="fas fa-check mr-2"></i>Salva</button>
                            <?php
                                if(isset($utente)) {
                            ?>
                                <button type="button" class="btn btn-warning w-100" onclick="location.href='../controller/controllerUtenti.php?operazione=duplicaUtente&idUtente=<?php echo $utente["id"] ?>';"><i class="far fa-clone mr-2"></i>Duplica</button>
                            <?php
                                }
                            ?>
                        </div>
                        <div class="clearfix"></div>
                        
                        </form>
            
                        <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                            <div class="card-header collapsed" data-toggle="collapse" href="#ImmagineInEvidenza">
                                <a class="card-title">
                                    Immagine profilo
                                </a>
                            </div>
                            <div id="ImmagineInEvidenza" class="collapse show">
                                <div class="card-body">
                                    <div class="img-container">
                                        <div class="azioni">
                                            <div class="btn-group" role="group" aria-label="">
                                                <button onclick="eliminaImmagineInEvidenza()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                            </div>
                                        </div>
                                        <img id="immagineInEvidenza" class="img-fluid w-100 mb-3" src="../<?php echo((isset($utente) && $utente["foto"]!="") ? $utente["foto"] : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                    </div>

                                    <form action="../controller/controllerUtenti.php" id="frmFileUpload-00" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                        <div class="dz-message">
                                            <i class="fas fa-file-upload fa-2x mb-2"></i>
                                            <h5>Trascina o carica qui l'immagine</h5>
                                        </div>
                                        <div class="fallback">
                                            <input name="file" type="file" />
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div><!--/Colonna secondaria -->
          
            </div>
        </div>
    </main>

        <?php 
            include "include/footer.php";

            include "include/modal/modalMenuComponenti.php";
                    
            include "include/modal/cambiaPassword.php";

            include "include/modal/operazioneCompletata.php";
            
            include "include/jsBaseAreaAmministrativa.php";
        ?>
        <!-- Dropzone -->
        <script type="text/javascript" src="../plugins/dropzone/dropzone.js"></script>
        <script>
            $(".singolo-file").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineInEvidenza").src= '../'+response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagine",
                    idUtente:<?php echo $utente["id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            });  	
            
            function aggiungiAGruppo() {
                var idGruppo = document.getElementById("gruppoDaAggiungere").value;
                
                if(idGruppo == 0) {
                    alert("Seleziona il gruppo a cui vuoi aggiungere questo utente");
                }
                else {
                    $.ajax({
                        type:"POST",
                        url:"../controller/controllerUtenti.php",
                        data:{
                            operazione:"aggiungiAGruppo",
                            idUtente:<?php echo $utente["id"] ?>,
                            idGruppo:idGruppo
                        },
                        success:function(result) {
                            if(result=="ok") {
                                 stampaGruppiAssociatiUtente();
                            }
                            else {
                                alert(result);
                            }
                        },
                        error: function(xhr,status,error) {
                            alert(status+" "+error);
                        }
                    });
                }
            }
            
            function eliminaDalGruppo(idGruppo) {
               
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerUtenti.php",
                    data:{
                        operazione:"eliminaDalGruppo",
                        idUtente:<?php echo $utente["id"] ?>,
                        idGruppo:idGruppo
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("divGruppo"+idGruppo).className = "d-none";
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function stampaGruppiAssociatiUtente() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerUtenti.php",
                    data:{
                        operazione:"stampaGruppiAssociatiUtente",
                        idUtente:<?php echo $utente["id"] ?>
                    },
                    success:function(result) {
                        document.getElementById("elencoGruppiUtenti").innerHTML = result;
                    },
                    error: function(xhr,status,error) {
                        alert(status+" "+error);
                    }
                });
            }
            
            function eliminaImmagineInEvidenza() {
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerUtenti.php",
                    data:{
                        operazione:"eliminaImmagineInEvidenza",
                        idUtente:<?php echo $utente["id"] ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineInEvidenza").src="../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
             jQuery(document).ready(function($) {
                $('#passwordUtente').password({
                  shortPass: '<span class="pwd-corta">La password è troppo corta, usa una password <strong>FORTE</strong> per scongiurare attacchi al tuo sito</span>',
                  badPass: '<span class="pwd-insufficiente">Insufficiente. Prova a combinare lettere e numeri</span>',
                  goodPass: '<span class="pwd-media">Media, aggiungi un carattere speciale per renderla più sicura</span>',
                  strongPass: '<span class="pwd-forte">Password forte</span>',
                  containsUsername: '<span class="pwd-corta">La tua password contiene lo username! Per motivi di sicurezza è bene sia diversa</span>',
                  enterPass: '',
                  showPercent: false,
                  animate: false,
                  minimumLength: 6,
                });
            });
        </script>
        
        
  </body>
</html>
